<?php
/**
 * Single Product
 *
 * @author      NanoAgency
 * @link        http://nanoagency.co
 * @copyright   Copyright (c) 2015 NanoAgency
 * @license     GPL v2
 */

$padding='';
$share_facebook     = get_theme_mod('nerubian_share_facebook',false);
$share_twitter      = get_theme_mod('nerubian_share_twitter',false);
$share_google       = get_theme_mod('nerubian_share_google',false);
$share_linkedin     = get_theme_mod('nerubian_share_linkedin',false);
$share_pinterest    = get_theme_mod('nerubian_share_pinterest',false);
$image_meta         = get_theme_mod('nerubian_image_meta',true);

$share_left         = get_theme_mod('nerubian_share_position','fixed');
$ads_single_right   = get_theme_mod('nerubian_ads_single_article');

if(isset($_GET['share_left'])){
    $share_left=$_GET['share_left'];
}
if(isset($_GET['ads_right'])){
    $ads_single_right=$_GET['ads_right'];
}

?>
<div class="wrap-content" role="main">
    <div class="container">
        <?php
        // Start the loop.
        while ( have_posts() ) : the_post();?>
            <div class="entry-header container-box clearfix">
                <header class="entry-header-title">
                    <?php  the_title( '<h1 class="entry-title">', '</h1>' ); ?>
                </header>
                <!-- .entry-header -->
                <?php nerubian_excerpt(); ?>

                <?php if(get_theme_mod('nerubian_avatar_meta',true)):?>
                    <div class="entry-avatar clearfix">
                        <?php
                        $author_bio_avatar_size = apply_filters( 'buggy_author_bio_avatar_size', 45 );
                        echo get_avatar( get_the_author_meta( 'user_email' ), $author_bio_avatar_size );
                        ?>

                        <div class="avatar-meta">
                            <span class="author-title">
                                <a class="author-link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
                                    <?php echo esc_attr(get_the_author()); ?>
                                </a>
                            </span>
                            <span class="post-date">
                                <?php if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
                                    $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

                                    if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
                                        $time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
                                    }

                                    $time_string = sprintf( $time_string,
                                        esc_attr( get_the_date( 'c' ) ),
                                        get_the_date(),
                                        esc_attr( get_the_modified_date( 'c' ) ),
                                        get_the_modified_date()
                                    );

                                    printf( '<span class="posted-on"><span class="screen-reader-text">%1$s </span><a href="%2$s" rel="bookmark">%3$s</a></span>',
                                        _x( 'Posted on', 'Used before publish date.', 'nerubian' ),
                                        esc_url( get_permalink() ),
                                        $time_string
                                    );
                                }
                                ?>
                            </span>
                        </div>
                    </div>
                <?php endif;?>
            </div>
        <?php endwhile; ?>

        <div class="row single-main-content">
            <div class="main-content content-full col-sx-12 col-sm-12 col-md-12 col-lg-12">
                <div class="content-inner">
                    <?php
                    // Start the loop.
                    while ( have_posts() ) : the_post();?>
                    <div class="box box-article">
                        <article id="post-<?php the_ID(); ?>" <?php  post_class();?>>
                            <?php if(has_post_format('gallery') & $image_meta) : ?>
                                <?php $images = get_post_meta( $post->ID, '_format_gallery_images', true ); ?>
                                <?php if($images) : ?>
                                    <div class="post-image single-image">
                                        <ul class="owl-single">
                                            <?php foreach($images as $image) : ?>
                                                <?php $the_image = wp_get_attachment_image_src( $image, 'full' ); ?>
                                                <?php $the_caption = get_post_field('post_excerpt', $image); ?>
                                                <li><img src="<?php echo esc_url($the_image[0]); ?>" <?php if($the_caption) : ?>title="<?php echo esc_attr($the_caption); ?>"<?php endif; ?> /></li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                <?php endif; ?>

                            <?php elseif(has_post_format('video') & $image_meta) : ?>

                                <div class="embed-responsive single-image embed-responsive-16by9 post-video single-video embed-responsive embed-responsive-16by9">
                                    <?php $sp_video = get_post_meta( get_the_ID(), '_format_video_embed', true ); ?>
                                    <?php if(wp_oembed_get( $sp_video )) : ?>
                                        <?php echo wp_oembed_get($sp_video); ?>
                                    <?php else : ?>
                                        <?php echo esc_url($sp_video); ?>
                                    <?php endif; ?>
                                </div>

                            <?php elseif(has_post_format('audio') & $image_meta ) : ?>

                                <div class="post-image audio single-image single-audio">
                                    <?php $sp_audio = get_post_meta( $post->ID, '_format_audio_embed', true ); ?>
                                    <?php if(wp_oembed_get( $sp_audio )) : ?>
                                        <?php echo str_replace($search, $replace, wp_oembed_get($sp_audio)); ?>
                                    <?php else : ?>
                                        <?php echo str_replace('','', $sp_audio); ?>
                                    <?php endif; ?>
                                </div>

                            <?php else : ?>
                                <?php if(has_post_thumbnail() & $image_meta ) : ?>
                                    <?php if(!get_theme_mod('sp_post_thumb')) : ?>
                                        <div class="post-image single-image">
                                            <?php  ?>
                                            <?php $thumbnail_full = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "full" ); ?>
                                            <?php $thumbnail_src = wp_get_attachment_image_src( get_post_thumbnail_id( get_the_ID() ), "full" ); ?>
                                            <?php
                                            $thumb_id = get_post_thumbnail_id(get_the_ID());
                                            $thumb_img = get_the_post_thumbnail_caption(get_the_ID());
                                            $alt = get_post_meta($thumb_id, '_wp_attachment_image_alt', true);
                                            ?>
                                            <figure class="wp-single-image">
                                                <a href="<?php echo esc_attr($thumbnail_full[0]);?>" data-size="<?php echo esc_attr($thumbnail_full[1]); ?>x<?php echo esc_attr($thumbnail_full[2]); ?>">
                                                    <img  class="wp-post-image" src="<?php echo esc_attr($thumbnail_src[0]);?>" alt="<?php echo esc_attr($alt);?>"/>
                                                    <?php if($thumb_img) { ?>
                                                        <span class="caption-image"><?php echo esc_attr($thumb_img);?></span>
                                                    <?php }?>
                                                </a>
                                            </figure>
                                        </div>
                                    <?php endif; ?>
                                <?php endif; ?>
                            <?php endif; ?>

                            <div class="entry-content container-box clearfix">
                                <div class="entry-content-inner">
                                    <?php
                                    //ads
                                    if($ads_single_right) {?>
                                        <div class="ads_content_single ads-before-content">
                                            <?php echo wp_kses_post(get_theme_mod('nerubian_ads_rectangle'));?>
                                        </div>
                                    <?php }

                                    the_content();

                                    //ads
                                    if($ads_single_right) {?>
                                        <div class="advertising_content_single">
                                            <?php echo wp_kses_post(get_theme_mod('nerubian_ads_leaderboard'));?>
                                        </div>
                                    <?php }

                                    wp_link_pages( array(
                                        'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'nerubian' ) . '</span>',
                                        'after'       => '</div>',
                                        'link_before' => '<span class="page-numbers">',
                                        'link_after'  => '</span>',
                                        'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'nerubian' ) . ' </span>%',
                                        'separator'   => '<span class="screen-reader-text">, </span>',
                                    ) );

                                    ?>

                                </div>
                            </div>
                            <!--    Author bio.-->
                            <div class="entry-footer clearfix">
                                <div class="entry-footer-social clearfix">
                                    <div class="entry-footer-left">
                                        <?php get_template_part('templates/tag'); ?>
                                    </div>
                                    <div class="entry-footer-right show">
                                        <?php get_template_part('templates/share'); ?>
                                    </div>
                                </div>

                            </div>
                        </article>
                    </div>

                    <div class="box box-author">
                        <?php
                        if ( '' !== get_the_author_meta( 'description' ) ) {
                            get_template_part('templates/about_author');
                        }
                        ?>
                    </div>
                    <?php get_template_part('templates/post_pagination'); ?>

                    <?php

                    //comments
                    if(get_theme_mod('nerubian_comments',true)) {
                        if ( comments_open() || get_comments_number() ) :
                            comments_template();
                        endif;
                    }

                    //ads
                    if(get_theme_mod('nerubian_ads_single_comment')) {?>
                        <div class="advertising_content_single">
                            <?php echo wp_kses_post(get_theme_mod('nerubian_ads_leaderboard'));?>
                        </div>
                    <?php }

                    //related
                    if(get_theme_mod('nerubian_related')) {
                        get_template_part('templates/related_posts');
                    }


                    //video
                    if(get_theme_mod('nerubian_videos_box')) {
                        get_template_part('templates/layout/video-carousel');
                    }

                    //ads
                    if(get_theme_mod('nerubian_ads_single_comment')) {?>
                        <div class="advertising_content_single">
                            <?php echo  wp_kses_post(get_theme_mod('nerubian_ads_leaderboard'));?>
                        </div>
                    <?php }

                    //read more
                    if(get_theme_mod('nerubian_readmore_box')) {
                        get_template_part('templates/layout/content-load');
                    }

                    ?>
                    <!-- Root element of PhotoSwipe. Must have class pswp. -->
                    <div class="pswp" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="pswp__bg"></div>
                        <div class="pswp__scroll-wrap">
                            <div class="pswp__container">
                                <div class="pswp__item"></div>
                                <div class="pswp__item"></div>
                                <div class="pswp__item"></div>
                            </div>
                            <div class="pswp__ui pswp__ui--hidden">

                                <div class="pswp__top-bar">

                                    <div class="pswp__counter"></div>

                                    <button class="pswp__button pswp__button--close" title="Close (Esc)"></button>

                                    <button class="pswp__button pswp__button--share" title="Share"></button>

                                    <button class="pswp__button pswp__button--fs" title="Toggle fullscreen"></button>

                                    <button class="pswp__button pswp__button--zoom" title="Zoom in/out"></button>

                                    <div class="pswp__preloader">
                                        <div class="pswp__preloader__icn">
                                            <div class="pswp__preloader__cut">
                                                <div class="pswp__preloader__donut"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="pswp__share-modal pswp__share-modal--hidden pswp__single-tap">
                                    <div class="pswp__share-tooltip"></div>
                                </div>

                                <button class="pswp__button pswp__button--arrow--left" title="Previous (arrow left)">
                                </button>

                                <button class="pswp__button pswp__button--arrow--right" title="Next (arrow right)">
                                </button>

                                <div class="pswp__caption">
                                    <div class="pswp__caption__center"></div>
                                </div>
                            </div>

                        </div>

                    </div>
                    <?php    // End the loop.
                    endwhile;
                    ?>
                </div>
            </div>
        </div><!-- .content-area -->
        <?php
        //ads
        if(get_theme_mod('nerubian_ads_single_bottom')) {?>
            <div class="advertising_single_bottom">
                <?php echo  wp_kses_post(get_theme_mod('nerubian_ads_bottom'));?>
            </div>
        <?php }?>

    </div>
</div>
